// Namespaces are:
// ACOMTools
//          .AmpPannel
//          .AntPannel
//          .Group
//          .Type
// Settings

var g_gui = null;


// Event handlers:
function OnAmpPannelLedClick(item,nBtn) {
    
}
function OnAmpPannelLedState(item,nState) {
    
}
function OnAmpPannelForwardPowerClick(f) {
    
}
function OnAmpPannelReflectedPowerClick(f) {
    
}
function OnAntPannelPosition(nPos) {

}
// Constants
var g_correctP = 0;
var g_timeOut = 0;
var g_stopTune = false;
var g_WaitingQ = false;
var g_minTicks = 1; 

var rStart = 4;
var rEnd = 8;
var clrActiveLight = 0xFFFF00;
var clrActiveDark = 0x808000;
var clrNormalLight = 0xFF80;
var clrNormalDark = 0x8080;

function OnPacketReceived(p) {
	if (p.packetType != 0) return;
	if (p.rxGroup != ACOMTools.Group) return;
	var p1;	
    	switch (p.command) {
		case "P":
			g_gui.document.all("PCur").innerText = p.param(0);
			setIndicator(p.param(0));
			if (g_stopTune) return;
			if (p.param(0) >= 5 && p.param(0) <= 8) {
				// in range
				g_gui.document.all("info").innerText = "In range";
				g_correctP ++;
				if (g_timeOut > g_minTicks) {
                			// Ask amplifier
                
                			// Prepare
                			g_stopTune = true;
                			g_WaitingQ = true;
                			g_timeOut = 0;
                			// Disable user interface
                			DisableUI();
           				p1 = ACOMTools.Core.DefAmpPacket("Q");
            				ACOMTools.Transmit(p1);
            				return;
            			}
			} else {
				// out of range
				g_gui.document.all("info").innerText = "Out of range";
				g_correctP = 0;
			}
			SendPRequest();
		break;
		case "W1":
		
		break;
		case "Q0":
		    if (g_WaitingQ) {
		        TuneResult("Bad tunning: Default settings selected.");
		    }
		break;
		case "Q1":
		    if (g_WaitingQ) {
		        TuneResult("GOOD tunning: Settings saved in the amplifier memory.");
		    }
		break;
		case "Q2":
		    if (g_WaitingQ) {
		        TuneResult("FAILURE: Drive power unstable.");
		    }
		break;
		case "Q3":
		    if (g_WaitingQ) {
		        g_correctP = 0;
            		g_timeOut = 0;
                	g_stopTune = true;
            		g_WaitingQ = false;
            		setIndicator(0);
            		EnableUI();
                    }
                    p1 = ACOMTools.Core.DefAmpPacket("W7");
		    ACOMTools.Transmit(p1);
		    p1 = ACOMTools.Core.DefAmpPacket("S");
		    ACOMTools.Transmit(p1);
		break;
		case "O":
		    if (!g_stopTune) {
  	            	SendPRequest();
  	            }
		break;
	}
}

function OnDetachGUI() {
    g_gui = null;
}
function OnAttachGUI(gui) {
    // gui - pointer to the gui
    g_gui = gui;
    return true;
}
function OnInitialize() {
    return true;
}
function OnUnInitialize() {
    g_gui = null;
}

function OnTimer() {
    if (g_WaitingQ) {
        g_timeOut ++;
        if (g_timeOut > 10) {
            // Timeout
            g_gui.document.all("info").innerText = "Amplifier response timeout";
            g_correctP = 0;
	        g_timeOut = 0;
            g_stopTune = true;
	        g_WaitingQ = false;
	        EnableUI();
        }
    } else {
        if (!g_stopTune) {
            if (g_correctP > 0) {
            	g_timeOut ++;
            } else {
                g_timeOut = 0;
            }
        }
    }
}

// Misc
function TuneResult(txt) {
    g_gui.document.all("info").innerText = txt;
    g_correctP = 0;
	g_timeOut = 0;
    g_stopTune = true;
	g_WaitingQ = false;
	setIndicator(0);
	EnableUI();
}
function SendPRequest() {
	var p;
	p = ACOMTools.Core.Packet(ACOMTools.acomConstant("AmpTypeID"),ACOMTools.Group,"P");
	ACOMTools.Transmit(p);
}
function StopTune() {
    if (g_gui) {
        g_gui.document.all("info").innerText = "";
        setIndicator(0);
    }
    g_correctP = 0;
    g_timeOut = 0;
    g_stopTune = true;
    g_WaitingQ = false;
    EnableUI();
}
function StartTune(seconds) {
    if (!ACOMTools.IsConnected) ACOMTools.RaiseUIError(1,"Not connected");
    setIndicator(0);
    var p;
    ACOMTools.RaiseEvent("DBG","setting mode ....");
    if (!ACOMTools.Core.SetRangeUserMode(true)) {
        ACOMTools.RaiseEvent("DBG","User mode Not Set");
    	p = ACOMTools.Core.DefAmpPacket("W7");
    	ACOMTools.Transmit(p);
    	g_gui.document.all("info").innerText = "Please retry.";
    	return;
    }
    ACOMTools.RaiseEvent("DBG","User mode Set OK");
    g_minTicks = seconds;
    p = ACOMTools.Core.DefAmpPacket("O");
    ACOMTools.Transmit(p);
    g_gui.document.all("info").innerText = "Apply 10 to 20W Drive";
    g_correctP = 0;
    g_timeOut = 0;
    g_stopTune = false;
    g_WaitingQ = false;
}
function setIndicator(n) {
	var l = n-1;
	l = ((l > 11)?11:l);
	l = ((l < 0)?0:l);
	var i;
	for (i = 0; i < 11; i++) {
		if (i >= (rStart - 1) && i <= (rEnd - 1)) {
			// Active area
			if (i <= (l - 1)) {
				g_gui.document.all("ind")[i].style.backgroundColor = clrActiveLight;
			} else {
				g_gui.document.all("ind")[i].style.backgroundColor = clrActiveDark;
			}
		} else {
			// Normal/outer area
			if (i <= (l-1)) {
				g_gui.document.all("ind")[i].style.backgroundColor = clrNormalLight;
			} else {
				g_gui.document.all("ind")[i].style.backgroundColor = clrNormalDark;
			}
		}
	}
}
function DisableUI() {
    g_gui.document.all("StartBtn").disabled = true;
    g_gui.document.all("StopBtn").disabled = true;
}
function EnableUI() {
    g_gui.document.all("StartBtn").disabled = false;
    g_gui.document.all("StopBtn").disabled = false;
}