// Namespaces are:
// ACOMTools
//          .AmpPannel
//          .AntPannel
//          .Group
//          .Type
// Settings

var g_gui = null;


// Event handlers:
function OnAmpPannelLedClick(item,nBtn) {
    
}
function OnAmpPannelLedState(item,nState) {
    
}
function OnAmpPannelForwardPowerClick(f) {
    
}
function OnAmpPannelReflectedPowerClick(f) {
    
}
function OnAntPannelPosition(nPos) {

}
var g_u = null;
var g_v = null;
function OnPacketReceived(p) {
	if (p.packetType != 0) return;
    switch (p.command) {
		case "MM":
			ClearLeds();
			StatusMessage("RCU is in measure process - stop it first");
		break;
		case "b":
		case "e":
		case "f":
		case "h":
		case "i":
		case "j":
		case "k":
		case "l":
		case "m":
		case "n":
		case "o":
		case "p":
		case "q":
		case "r":
		case "s":
		case "t":
		case "w":
		case "x":
		case "y":
		case "z":
			if (g_gui) {
				if (p.command == g_u) {
					g_gui.document.all("U").innerText = ProcessData(p);
				}
				if (p.command == g_v) {
					g_gui.document.all("V").innerText = ProcessData(p);
				}
			}
			StatusMessage("Data received");
		break;
	}
}

function OnDetachGUI() {
    g_gui = null;
}
function OnAttachGUI(gui) {
    // gui - pointer to the gui
    g_gui = gui;
    return true;
}
function OnInitialize() {
    return true;
}
function OnUnInitialize() {
    g_gui = null;
}
function OnGetDescription() {
    return "Amplifier measurements";
}

function OnTimer() {
    
}

// Own API
function StartMeasuring(u,v) {
	if (!ACOMTools.IsConnected) {
		ACOMTools.RaiseUIError(1,"Not connected");
		ClearLeds();
		StatusMessage("Not connected!");
		return false;
	}
	g_u = u;
	g_v = v;
	var p = ACOMTools.Core.Packet(ACOMTools.acomConstant("AmpTypeID"),ACOMTools.Group,"MM");
	ACOMTools.Transmit(p);
	p = ACOMTools.Core.Packet(ACOMTools.acomConstant("AmpTypeID"),ACOMTools.Group,"M");
	p.param(0) = u;
	p.param(1) = v;
	ACOMTools.RaiseEvent("DEBUG","Before transmit");
	ACOMTools.Transmit(p);
	StatusMessage("Request sent ... Waiting for response");
	return true;
}
function StopMeasuring() {
	ClearLeds();
	StatusMessage(" ");
	if (ACOMTools.IsConnected) {
		var p = ACOMTools.Core.Packet(ACOMTools.acomConstant("AmpTypeID"),ACOMTools.Group,"MM");
		ACOMTools.Transmit(p);
	}
}
function StatusMessage(str) {
	if (g_gui) {
		g_gui.document.all("info").innerText = str;
	}
}
function ClearLeds() {
	if (g_gui) {
		g_gui.document.all("UI").innerText = "-";
		g_gui.document.all("VI").innerText = "-";
		g_gui.document.all("U").innerText = "-";
		g_gui.document.all("V").innerText = "-";
	}
}
function ProcessData(p) {
	var tmp;
	switch (p.command) {
		case "b":
			return ( (p.param(0)/2) + " V");
		case "e":
			return ( (p.param(0) * p.param(1) * 0.16) + " W");
		case "f":
			return ( ((p.param(0) * p.param(0)) / 512) + " W");
		case "h":
			return ( (( (p.param(0) * 256) + p.param(1) ) * 2) + " kHz");
		case "i":
			return ( (( p.param(0) * p.param(0) ) / 16) + " W");
		case "j":
			return ( (p.param(0) / 16) + " V");
		case "k":
			tmp =  (10 * Math.log((p.param(0) * p.param(0) * 32)/ (p.param(1) * p.param(1))));
			if (isNaN(tmp)) {
				return "???";
			} else {
				return ((tmp / 2.3026) + " dB");
			}
		case "l":
			return ( (p.param(0) * 16) + " V");
		case "m":
		case "n":
			return ( (p.param(0) / 16) + " A");
		case "o":
			return ( (p.param(0) / 10) + " mA");
		case "p":
			return ( (p.param(0) * 10) + " mA");
		case "q":
			return ( p.param(0) + " mA");
		case "r":
			return ( (p.param(0) * 10 / 8) + " V");
		case "s":
			return ( (p.param(0) * 12) + " V");
		case "t":
			return ( (p.param(0) * p.param(0) / 100) + " W");
		case "w":
			return ( (p.param(0) * 2) + " V");
		case "x":
		case "y":
			return ( ((p.param(0) - 136) * 2) + " C");
		case "z":
			tmp = ( (2.5 * p.param(0) + p.param(1))/(2.5 * p.param(0) - p.param(1)) );
			if (isNaN(tmp)) {
				return "???";
			} else {
				return tmp + " ";
			}
	}
	return "-";
}