// Namespaces are:
// ACOMTools
//          .AmpPannel
//          .AntPannel
//          .Group
//          .Type
// Settings

var g_gui = null;
var g_LogAll = false;


// Event handlers:
function OnAmpPannelLedClick(item,nBtn) {
    // item - item name
    // nBtn - 0:left, 1:right
}
function OnAmpPannelLedState(item,nState) {
    // item - item name
    // nState - 0:Off, 1:Onn
}
function OnAmpPannelForwardPowerClick(f) {
    // f - volume
}
function OnAmpPannelReflectedPowerClick(f) {
    // f - volume
}
function OnAntPannelPosition(nPos) {
    // nPos - position set

}
function OnPacketReceived(p) {
    // p - ACOM App packet
    if (g_gui) {
        var lb = g_gui.document.all("DBG");
        var opt,i;

        opt = g_gui.document.createElement("OPTION");
        opt.value = "";
        switch (p.packetType) {
            case 1:
                if (g_LogAll) {
                    opt.text = "FP " + p.volume;
                    lb.options.add(opt);
                }
            break;
            case 2:
                if (g_LogAll) {
                    opt.text = "RP " + p.volume;
                    lb.options.add(opt);
                }
            break;
            case 0:
                if (!g_LogAll) {
                    if (p.command == "L" || p.command == "I") return;
                }
                opt.text = p.command + " " + p.paramString;
                lb.options.add(opt);
                for (i = 0; i < p.paramCount; i++) {
                    opt = g_gui.document.createElement("OPTION");
                        opt.text = "    p[" + i + "]=" + p.param(i);
                        lb.options.add(opt);
                }      
            break;
        }
        
    }
}

function OnDetachGUI() {
    g_gui = null;
}
function OnAttachGUI(gui) {
    // gui - pointer to the gui
    g_gui = gui;
    return true;
}
function OnInitialize() {
    return true;
}
function OnUnInitialize() {
    g_gui = null;
}
function OnGetDescription() {
    return "Sample extension";
}
var g_Ticks = 0;
function OnTimer() {
    g_Ticks ++;
    if (g_gui) {
        if ( (g_Ticks % 10) == 0 ) g_gui.document.all("TIMER").innerText = g_Ticks;
    }
}

/// Called from the GUI
function LightAFire() {
    ACOMTools.AmpPannel("Plate").checked = !ACOMTools.AmpPannel("Plate").checked;
}
function SendPacket(GROUP,TYPE,CMD,P1,P2,P3,P4,P5) {
    var p = ACOMTools.CreateObject("newObjects.USPC.ACOMSerialProtocolPacket");
    var lb = g_gui.document.all("DBG");
    p.command = CMD;
    p.rxType = TYPE;
    p.rxGroup = GROUP;
    p.txType = ACOMTools.Type;
    p.txGroup = ACOMTools.Group;
    if (p.paramCount > 0) p.param(0) = P1;
    if (p.paramCount > 1) p.param(1) = P2;
    if (p.paramCount > 2) p.param(2) = P3;
    if (p.paramCount > 3) p.param(3) = P4;
    if (p.paramCount > 4) p.param(4) = P5;
    
    ACOMTools.Transmit(p);
}
