// Namespaces are:
// ACOMTools
//          .AmpPannel
//          .AntPannel
//          .Group
//          .Type
// Settings

// Utility
function CreateDriver() {
	if (g_Pos >= 0 && g_Pos < 10) {
		var clsid;
		clsid = Settings("Driver" + g_Pos);
		if (clsid != "") {
			g_Driver = ACOMTools.CreateObject(clsid);
		} else {
			g_Driver = ACOMTools.CreateObject("{E28A64AB-5592-11D5-99AC-0040332BA2EA}");
		}
		return true;
	}
	return false;
}


// Event handlers:
function OnAmpPannelLedClick(item,nBtn) {
    // item - item name
    // nBtn - 0:left, 1:right
    //if (g_gui) g_gui.document.write("Hello world:" + item + "," + nBtn + "<BR>");
}
function OnAmpPannelLedState(item,nState) {
    // item - item name
    // nState - 0:Off, 1:Onn
}
function OnAmpPannelForwardPowerClick(f) {
    // f - volume

}
function OnAmpPannelReflectedPowerClick(f) {
    // f - volume
}
function OnAntPannelPosition(nPos) {
    ACOMTools.RaiseEvent("DEBUG","OnAntPannelPosition");
    UpdateAntSwitch(nPos);

}
function ExecuteRTSDTRCustomCommand(dtr,rts) {
    if (g_Driver != null) {
        //if (!g_Driver.CheckState(0x0004)) {
        //    ACOMTools.RaiseUIError(1,"USPC driver is not connected to a protocol translator in module AUXSwitch");
        //    return;
        //}
        var packet = ACOMTools.CreateObject("{E28A64D3-5592-11D5-99AC-0040332BA2EA}");
        packet.packetType = 3;
        packet.command = (rts)?"SETRTS":"CLRRTS";
        g_Translator.Transmit(packet);
        packet.command = (dtr)?"SETDTR":"CLRDTR";
        g_Translator.Transmit(packet);
    } else {
        ACOMTools.RaiseUIError(1,"USPC driver is not initialized/created in module AUXSwitch");
    }
}
function OnAntPannelAuxPosition(nPos) {
    ACOMTools.RaiseEvent("DEBUG","OnAntPannelAuxPosition");
    if (g_Pos < 0) return;
    if (g_Cnt < 2) return;
    if (g_Driver == null) {
        if (!Connect()) return;
    }
    b0 = false;
    b1 = false;
    b0 = ( ( (nPos - 1) & 0x01) > 0 );
    b1 = ( ( (nPos - 1) & 0x02) > 0 );
    if (!g_SWP) ExecuteRTSDTRCustomCommand(b0,b1);
    else ExecuteRTSDTRCustomCommand(b1,b0);
}
function Connect() {
    if (g_Pos >= 0 && g_Pos < 10) {
        ACOMTools.RaiseEvent("DEBUG","Creating driver ...");
		if (!CreateDriver()) {
			ACOMTools.RaiseUIError(1,"Error creating USPC driver for the AUX on switch position " + g_Pos);
			return false;
		}
        g_Driver.SetConnectString(Settings("ConnectString"+g_Pos));
        g_Driver.SetTranslator(g_Translator);     
        g_Driver.Open(g_mode);
        return true;
    } 
    return false;
}
var g_mode = 0x8 | 0x10 | 0x20 | 0x0004 | 0x1000;
var g_Pos = -1;
var g_Cnt =  0;
var g_Driver = null;
var g_DriverID = null;
var g_SWP = 0;
function UpdateAntSwitch(n) {
    var dummy;
    ACOMTools.RaiseEvent("DEBUG","Update state begins ...");
    if (g_Driver != null) {
        ACOMTools.RaiseEvent("DEBUG","Releasing driver ...");
        g_Driver.Close();
        dummy = g_Driver.DetachTranslator();
        g_Driver = null;
    }
    g_Pos = n;
    if (g_Pos < 0) {
        ACOMTools.RaiseEvent("DEBUG","Clearing pannel ...");
        ACOMTools.AntPannel.AuxCount = 0;
        return;
    }
    g_Cnt = Settings.Option("AuxPosCnt" + n);

    // Load names
    var i;
    ACOMTools.AntPannel.AuxCount = g_Cnt;
    ACOMTools.RaiseEvent("DEBUG","Cnt = " + g_Cnt);
    for (i = 1; i <= g_Cnt; i++) {
        ACOMTools.AntPannel.AuxName(i) = Settings("Label" + n + "x" + i);
    }         
    g_SWP = Settings.Option("SwapRTSDTR" + n);
    ACOMTools.RaiseEvent("DEBUG","End update");
}
function UpdateAntSwitchCfg(n) {
    if (n == g_Pos) UpdateAntSwitch(n);
}
function OnPacketReceived(p) {
    // p - ACOM App packet
        if (p.packetType == 0) {
            switch (p.command) {
                case "W1":
                    UpdateAntSwitch(p.param(1));
                break;
                case "W4":
                    UpdateAntSwitch(p.param(0));
                break;
            }
        }
}
var g_Translator = null;
function OnInitialize() {
    ACOMTools.AntPannel.AuxCount = 0;
    g_Translator = ACOMTools.CreateObject("{E28A64BE-5592-11D5-99AC-0040332BA2EA}");
    return true;
}
function OnUnInitialize() {
    var dummy;
    if (g_Driver) {
        g_Driver.Close();
        dummy = g_Driver.DetachTranslator();
    }
    g_Driver = null;
    g_Translator = null;
    ACOMTools.AntPannel.AuxCount = 0;
}
function OnGetDescription() {
    return "AUXSwitch extension";
}

